/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.model.animation;

import dev.mayaqq.estrogen.client.cosmetics.model.animation.Animatable;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.Animation;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.AnimationDefinition;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.Keyframe;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.VectorType;
import dev.mayaqq.estrogen.utils.Registry;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Animations {
    public static final Registry<Keyframe.Interpolation> INTERPOLATIONS = new Registry();
    public static final Registry<VectorType> VECTOR_TYPES = new Registry();
    private static int animationTicks = 0;

    public static void animate(Animatable.Provider source, AnimationDefinition definition, Vector3f animationVecCache) {
        long accumulatedTime = Animations.getAnimationTime();
        definition.animations().forEach((key, animations) -> source.getAny((String)key).ifPresent(animatable -> animations.forEach(animation -> {
            Keyframe[] keyframes = animation.keyframes();
            float elapsed = Animations.getElapsedSeconds(animation, accumulatedTime);
            int last = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, index -> elapsed <= keyframes[index].timestamp()) - 1);
            int next = Math.min(keyframes.length - 1, last + 1);
            Keyframe lastFrame = keyframes[last];
            Keyframe nextFrame = keyframes[next];
            float sinceLast = elapsed - lastFrame.timestamp();
            float delta = next != last ? class_3532.method_15363((float)(sinceLast / (nextFrame.timestamp() - lastFrame.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
            nextFrame.interpolation().apply(animationVecCache, delta, keyframes, last, next, 1.0f);
            animation.target().apply((Animatable)animatable, (Vector3fc)animationVecCache);
        })));
    }

    private static float getElapsedSeconds(Animation animation, long accumulatedTime) {
        double f = (float)accumulatedTime / 1000.0f;
        return (float)f % animation.seconds();
    }

    public static void tick() {
        if (animationTicks == 30000000) {
            animationTicks = 0;
        }
        ++animationTicks;
    }

    public static long getAnimationTime() {
        return (long)(class_3532.method_16439((float)class_310.method_1551().method_1488(), (float)animationTicks, (float)(animationTicks + 1)) * 50.0f);
    }
}

